/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.util.functions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.util.functions.IFunction;
import dev.toma.gunsrpg.resource.util.functions.IFunctionAdapter;
import net.minecraft.util.JSONUtils;

public class RangedFunction
implements IFunction {
    public static final IRangeComparator BETWEEN_INCLUSIVE = (input, min, max) -> input >= min && input <= max;
    public static final IRangeComparator BETWEEN_EXCLUSIVE = (input, min, max) -> input > min && input < max;
    private final IRangeComparator rangeComparator;
    private final int min;
    private final int max;

    public RangedFunction(IRangeComparator rangeComparator, int min, int max) {
        this.rangeComparator = rangeComparator;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean canApplyFor(int input) {
        return this.rangeComparator.isWithinRange(input, this.min, this.max);
    }

    public static final class Adapter
    implements IFunctionAdapter<RangedFunction> {
        private final IRangeComparator rangeComparator;

        public Adapter(IRangeComparator rangeComparator) {
            this.rangeComparator = rangeComparator;
        }

        @Override
        public RangedFunction resolveFromJson(JsonObject object) throws JsonParseException {
            int max;
            int min = JSONUtils.func_151203_m((JsonObject)object, (String)"min");
            if (min > (max = JSONUtils.func_151203_m((JsonObject)object, (String)"max"))) {
                throw new JsonSyntaxException("'max' value cannot be smaller than 'min' value");
            }
            return new RangedFunction(this.rangeComparator, min, max);
        }
    }

    @FunctionalInterface
    public static interface IRangeComparator {
        public boolean isWithinRange(int var1, int var2, int var3);
    }
}

